function [Mx,My] = find_logical(M)
% This function is a logical alternative of the inbuilt find function

%%Usage examples
 % A =randi(4,5);
 % [Mx My]=find_logical(A==1);
 
 % A= randi(10,100,1);;
 % [Mx My]=find_logical(A==5);

%% input 
% M : 1D or 2D matrix
%% output
% Mx :row number/s of the element/s searched in matrix M
% My :column number/s of the element/s searched in matrix M


[r c]=size(M);

AB=repmat((1:r)',[1 c]);
AB1=repmat((1:c),[r 1]);

Mx=AB(M==1);
My=AB1(M==1);
end

